<?php

namespace Motors_E_W\Pro\Widgets;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\ContentControls\TextControl;
use STM_E_W\Widgets\Controls\ContentControls\MediaControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class ListingsMap extends WidgetBase {
	use TextControl;
	use NumberControl;
	use SwitcherControl;
	use MediaControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_enqueue(
			self::get_name(),
			MOTORS_ELEMENTOR_WIDGETS_PATH,
			MOTORS_ELEMENTOR_WIDGETS_URL,
			MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION,
			array(
				'jquery',
				'stm_marker_cluster',
				'stm_gmap',
				'stm-google-places',
				'elementor-frontend',
			),
		);
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-listings-map';
	}

	public function get_title() {
		return esc_html__( 'Listings Map', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'stmew-google-map';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'section_content', __( 'General', 'stm-elementor-widgets' ) );

		$this->stm_ew_add_text(
			'address',
			array(
				'label' => __( 'Address', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_text(
			'lat',
			array(
				'label'   => __( 'Lattitute', 'motors-elementor-widgets' ),
				'default' => 36.169941,
			),
		);

		$this->stm_ew_add_text(
			'lng',
			array(
				'label'   => __( 'Longitude', 'motors-elementor-widgets' ),
				'default' => -115.139830,
			),
		);

		$this->stm_ew_add_number(
			'search_radius',
			array(
				'label' => __( 'Search Radius', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_number(
			'map_height',
			array(
				'label' => __( 'Map Height', 'motors-elementor-widgets' ),
			)
		);

		$this->stm_ew_add_number(
			'map_zoom',
			array(
				'label'   => __( 'Map Zoom', 'motors-elementor-widgets' ),
				'default' => 4,
			)
		);

		$this->stm_ew_add_switcher(
			'map_scrollwheel',
			array(
				'label'   => __( 'Map ScrollWheel', 'motors-elementor-widgets' ),
				'default' => 'yes',
			),
		);

		$this->stm_ew_add_media(
			'pin_image',
			array(
				'label' => __( 'Pin Image', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_media(
			'cluster_image',
			array(
				'label' => __( 'Cluster Image', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_end_control_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		Helper::stm_ew_load_template( 'pro/widgets/listings-map', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}
}
